%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
% Finite Line Source          (FLS):  Eskilson 1987                       %
%                                                                         %
% Version July 2013           Nelson Molina-Giraldo Matrix Solutions Inc. %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function T = T_FLS(x,y,ro,z,H,lm,Cm,vT,t,QL,ax,ay)
%--Analytical solution----------------------------------------------------%
Dt = lm/Cm;             % thermal diffusivity [m2/s]
r = sqrt(x.^2+y.^2);    % radial distance [m]

% Temperature change 
T = QL*(1/4/pi/lm)*...
    (quadgk(@(ze) erfc(sqrt(r.^2+(z-ze).^2)/2/sqrt(Dt*t))./...
     sqrt(r.^2+(z-ze).^2),0,H)-...
     quadgk(@(ze) erfc(sqrt(r.^2+(z-ze).^2)/2/sqrt(Dt*t))./...
     sqrt(r.^2+(z-ze).^2),-H,0));

%--Nomenclature-----------------------------------------------------------%
% x,y: x-y coordinates [m]
% ro: borehole radius [m]
% z: vertical coordinate [m]
% H: borehole length [m]
% lm: bulk thermal conductivity [W/m/K]
% Cm: volumetric heat capacity of the porous medium [J/m3/K] 
% vT: heat transport velocity [m/s]
% t: simulation time [s]
% QL : heat flow rate per unit length of borehole [W/m]
% ax: longitudinal thermal dispersivity 
% ay: transverse thermal dispersivity
% Please note that there are some variables which are not used in the 
% current subfunction. 